# ========================================
# Breast Cancer Data Simulation Script - 
# Stepwise Gaussian Graphical Model
# (!) This is the EPC Case
# 
# Works in conjunction with:
# StepGraph R Package
# 
# ========================================

# -----------------------
# Generate Training Sets
# -----------------------

set.seed(1)
R = 100

breast_cancer = read.table("breast_cancer_data.csv", sep = ";", header = TRUE, dec = ".")

data_set = list()
for (r in 15:15){
  data_set = training_set(breast_cancer)
  save(data_set, file = paste("data_set_", r,".RData",sep = ""))
}

# ---------------------------
# Generate Simulation Output
# ---------------------------

R = 100

# Ginette: he cambiado la siguiente linea
for(r in 1:R){
  load(file = paste("data_set_", r,".RData",sep = ""))
  fit.Liang = equSAR(scale(data_set[[1]]),iMaxNei=as.integer(nrow(data_set[[1]])/log(nrow(data_set[[1]]))),
                     ALPHA1=0.05,ALPHA2=0.05,GRID=2,iteration=100)$Adj
  fit.omega.Liang = solcov(scale(data_set[[1]]), fit.Liang, tol=10^-10)$COV
  save(fit.omega.Liang, file = paste("Liang_opt_", r,".RData",sep = ""))
}

# Estimate precision matrix
R = 100
for(r in 1:R){
  load(file = paste("data_set_", r,".RData",sep = ""))
  fit.Liang = equSAR(scale(data_set[[1]]),iMaxNei=as.integer(nrow(data_set[[1]])/log(nrow(data_set[[1]]))),
                     ALPHA1=0.05,ALPHA2=0.05,GRID=2,iteration=100)$Adj
  save(fit.Liang, file = paste("Liang_Adj_", r,".RData",sep = ""))
}



