function [est] = Func_RestrictFit(fHandle_Fitting, x, y, ZeroOut)
% Fit a model resctricted to the nonzero entries of (vectorized) ZeroOut
% If y has more than 1 responses, since we only consider a vector
% multvariate model with *indepdendence* between all responses,
% the model fitting amounts to a single-response one on the vectorized model    

ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

[~, m] = size(y);
[n, p] = size(x);

oriX = x;
oriY = y;

if m > 1    

    y = reshape(y, [n * m, 1]); % vectorize to single response variable
    x = sparse(kron(eye(m), x));
end
if ZeroOutEffective
    est = zeros(p*m, 1);
    nontrivialInds = find(ZeroOut(:) ~= 0); % use vectorized ZeroOut to get the restricted indices
    x_restr = x(:, nontrivialInds);        
    est(nontrivialInds) = fHandle_Fitting(x_restr, y);       
else
    est = fHandle_Fitting(x, y);
end
if m > 1
    est = reshape(est, [p, m]);
end
end
