%% This is a demo for computing RRR data depth
%
% We generate some simulation data, use a rrr regression to
% obtain the estimates, and then calculate the rrr depth for the estimate. 
% The main step is the calling of function Func_RRR_Depth

clear; close all; clc;
addpath(genpath(pwd)) 
rng('default')
rng(0)

% Specify problem dimensions and other parameters in generating the data
family = 'Gaussian';
n = 100;
p = 20;
m = 20;
fprintf('n = %d, p = %d, m = %d \n', n, p, m);
betaTrue_rank = 3;
designcorr = 0.2; 
betaTrue_strenth = 1; 
betaTrue = betaTrue_strenth *  rand(p, betaTrue_rank) * rand(m, betaTrue_rank)';

r = 5; % the rank parameter in rank-r RRR depth, also the rank of the estimate

% Generate simulation data
X = randn(n, p);
corrMat = designcorr .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]); 
X = X * chol(corrMat);
Y = X * betaTrue(1:end, :) + 0.1 * randn(n, 1);

%% Get an RRR estimate as a test
[betaTarget, ~, ~, ~, ~] = Func_RRR(X, Y, r, 0);

%% Calculate the rank-r data depth of the given (matrix) estimate
% First, we construct the R matrix
R = -Funct_GLMResidual_Gradient(Y, X, betaTarget, family); 
% Then call the Func_RRR_Depth function  
opts = struct('V_method', '2ndAcc', 'L_method', '2ndAcc', 'numOfInitValues', 10, 'maxiter', 3e+3, 'tolgrad', 1e-5, 'tol', 1e-3, 'V_tol', 1e-4, 'L_tol', 1e-4, 'V_bcd_maxiter', 100, 'L_bcd_maxiter', 100);
[depthval, time, Vopt, Lopt] = Func_RRR_Depth(X, Y, betaTarget, R, r, [], opts);  % the parameter rho_depth takes the default


    
fprintf('================================================================================ \n');
fprintf('The rank-%d RRR depth for the current estimate is %.4f. \n',r, depthval);


