function [Vs] = Funct_InitVs(Xt, R, NumInits, ZeroOut)
%==========================================================================
% This function performs subsampling to give some initial V directions
%------------------------ Input Variables ---------------------------------
% Xt              - transpose of X
% R               - residual matrix
% NumInits        - number of initial Vs required
% ZeroOut         - field mat: a binary matrix of the same size of B. 0 means the position should be fixed at 0
%------------------------ Output Variables ---------------------------------
% Vs              - a collection of samples of initial Vs obtained
%==========================================================================
% A spherical pca for initializing the directions of V is included
%==========================================================================
[p, n] = size(Xt);
[~, m] = size(R);
if ~exist('ZeroOut', 'var')
    ZeroOut =[];
end
ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

Vs = zeros(p, m, NumInits);
addSPCA = 1; % 0; % 

sampleinds = [];
auxind = 1; i = 1;
while i <= NumInits - addSPCA
    if auxind > length(sampleinds) 
%         disp('generating random numbers..')
        sampleinds = randperm(n, min(n, (NumInits - addSPCA)));
        auxind = 1;
    end    
    tInd = sampleinds(auxind);
    
    V = -Xt(:, tInd) * R(tInd, :); %Notice the negative sign (which is crucial) !!!
    %%%%
    if ZeroOutEffective
        V = V .* ZeroOut.mat;    
    end
    %%%%
    if norm(V,'fro') > 1e-4
        Vs(:, :, i) = V / norm(V,'fro');
        i = i + 1;
    end
    auxind = auxind + 1;
end
if addSPCA
    % Add an initial V from spherical pca
    tV = Funct_SPCA_V(Xt, R);
    %%%%
    if ZeroOutEffective
        tV = tV .* ZeroOut.mat;
        tV = tV / (norm(tV, 'fro'));
    end
    %%%%
    Vs(:, :, NumInits) = tV;
end


end