function [S,f,gnorm] = aux_sparsity_depth_BCD_S(M, U,  Sini, zeta, LB, UB, opts)
%==========================================================================
% This function performs the S-block optimization in calculating sparsity depth.
% It is a constrained optimization problem.
%==========================================================================
% M = (X*V).*R + V.'*gamma*ones(n,1)/n;
% U = ones(n,1)*V.'/n;


Ut = U.';


% Solve the problem
funObj = @(S)Func_Grad_S(M, U, Ut, S,zeta);
[S,f,gnorm] = minConf_TMP(funObj,Sini,LB,UB, opts);
end

function [f, g] = Func_Grad_S(M, U, Ut, S,zeta)
Xdiag =  M + U*S;
switch nargout
    case 1
        [f1] = aux_Phi(Xdiag, zeta);
        f = sum(f1);
    case 2 % gradient required
        [f1,g1] = aux_Phi(Xdiag, zeta);
        f = sum(f1);
        g = Ut*g1; 
end
end


