function [V, L, t] = Func_RRR_Depth_InAnn_BCD(X, Xt, V_init, R, P_perp, L_init, Q_perp, lambda, opts, zeta, rho_depth)
%==========================================================================
% This function implements the BCD (alternative optimization) algorithm for solving the polished sparsity depth given zeta.
%------------------------ Input Variables ---------------------------------
% X               - design matrix
% Xt              - transpose of X
% V_init          - initial value of V 
% R               - residual matrix
% P_perp          - orthogonal complement to the P in compact SVD: B = P D Q'
% L_init          - initial value of L
% Q_perp          - orthogonal complement to the Q in compact SVD: B = P D Q'
% lambda          - the rth singular value of B
% opts            - Options for optimizing V and L
% zeta            - the annealing parameter for the heating oprocess (inverse cooling), which controls
%                   the steepness of the function in approximating the sign function 
% rho_depth       - a scale parameter added in the objective function to
%                   improve numerical performance
%------------------------ Output Variables ---------------------------------
% V               - the optimal projection direction of residuals 
% L               - the optimal (repametrized) slack variables/parameters 
% t 	          - number of iteration used
%==========================================================================

V = V_init;
L = L_init;


for t = 1 : opts.maxiter     
    % update V
    [V, grad_V_tmp] = aux_rrr_depth_BCD_V(X, Xt, V, R, P_perp, L, Q_perp, opts, zeta, rho_depth);
    
    % update L
    if ~isempty(L) %if L is not exsist the dpeth is regression depth
        [L, grad_L_tmp] = aux_rrr_depth_BCD_L(X, Xt, V, R, P_perp, L, Q_perp, lambda, opts, zeta, rho_depth);
    else
        grad_L_tmp = 0;
    end
    % convergence checking
    objfunc(t) = Funct_Obj_RRR_Depth(X, V, R, P_perp, L, Q_perp, zeta, rho_depth, 0);
    grad_V(t) = norm(grad_V_tmp, 'fro');
    grad_L(t) = norm(grad_L_tmp, 'fro');
    if t > 1 && ( (grad_V(t) < opts.tolgrad && grad_L(t) < opts.tolgrad )  || abs(objfunc(t) - objfunc(t - 1)) < opts.tol )    
        break
    end
    
end
end














