function[depth] = Funct_01DepthVal(X, R, V)
%==========================================================================
% This function computes the 0-1 depth (using 1_{>=0} as the measure)
%------------------------ Input Variables ---------------------------------
% X               - design matrix
% R               - residual matrix
% V               - The normal direction of the half-space 
%------------------------ Output Variables ---------------------------------
% depth           - the result of the depth
%==========================================================================

Xdiag =  sum((X*V).*R, 2); % diag( X * V * R')
% nonnegative_Xdiag = heaviside(Xdiag) + 1/2 * (Xdiag==0);
% depth = sum(nonnegative_Xdiag) / size(X,1);
depth = sum((Xdiag >= 0)) / size(X,1);

end