function candoit = canGetApproxGradient(problem)
% Checks whether an approximate gradient can be computed for this problem.
%
% function candoit = canGetApproxGradient(problem)
%
% Returns true if an approximate gradient of the cost function is provided
% in the given problem description, false otherwise.
% If a gradient is defined but no approximate gradient is defined
% explicitly, returns false.
%
% Even if this returns false, calls to getApproxGradient may succeed, as
% they will be redirected to getGradientFD. The latter simply requires
% availability of the cost in problem.
%
% See also: canGetGradient getGradientFD

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, Nov. 1, 2016.
% Contributors: 
% Change log: 

    candoit = isfield(problem, 'approxgrad');
    
end
